<?php
// formulario/verificar_disponibilidad.php - Mejorado: Valida código secreto y consentimiento, encripta celular
session_start();
require_once "config.php";

$conn->set_charset("utf8mb4");

if ($_SERVER["REQUEST_METHOD"] !== "POST" || !validateCSRF($_POST['csrf'] ?? '')) {
    error_log("Solicitud inválida o código secreto malo desde " . $_SERVER['REMOTE_ADDR']);
    http_response_code(400);
    die("Solicitud inválida. Intenta de nuevo.");
}

if (!isset($_POST['consent']) || $_POST['consent'] !== 'on') {
    die("Debes aceptar la política de privacidad.");
}

// Limpia todos los datos del POST
$apellidos = filter_var($_POST['apellidos'] ?? '', FILTER_SANITIZE_STRING);
$nombres = filter_var($_POST['nombres'] ?? '', FILTER_SANITIZE_STRING);
$curso = filter_var($_POST['curso'] ?? '', FILTER_SANITIZE_STRING);
$codigo = filter_var($_POST['codigo_credencial'] ?? '', FILTER_VALIDATE_INT);
$celular = $_POST['celular'] ?? '';
$club = filter_var($_POST['club'] ?? '', FILTER_SANITIZE_STRING);

if (empty($club) || empty($codigo)) {
    die("Datos incompletos.");
}

// Encripta celular
$celular_enc = encryptData($celular);

// Obtener datos del club
$sql = "SELECT limite, inscritos, tipo, precio FROM clubes WHERE nombre = ?";
$stmt = $conn->prepare($sql);
if (!$stmt) {
    die("Error en prepare: " . $conn->error);
}
$stmt->bind_param("s", $club);
$stmt->execute();
$result = $stmt->get_result();
if (!$result || $result->num_rows < 1) {
    die("Club no encontrado.");
}
$club_data = $result->fetch_assoc();
$club_data['nombre'] = $club;

$_SESSION['student_data'] = [
    'apellidos' => $apellidos,
    'nombres' => $nombres,
    'curso' => $curso,
    'codigo_credencial' => $codigo,
    'celular' => $celular_enc // Guardado encriptado
];
$_SESSION['club_data'] = $club_data;

// Verificar si ya existe inscripción para este usuario en el mismo club
$sqlCheck = "SELECT id, estado FROM estudiantes WHERE codigo_credencial = ? AND club = ?";
$stmtCheck = $conn->prepare($sqlCheck);
if (!$stmtCheck) {
    die("Error en prepare (chequeo): " . $conn->error);
}
$stmtCheck->bind_param("ss", $codigo, $club);
$stmtCheck->execute();
$resCheck = $stmtCheck->get_result();

if ($resCheck && $resCheck->num_rows > 0) {
    $rowCheck = $resCheck->fetch_assoc();
    $estadoExistente = $rowCheck['estado'];
    $inscId = $rowCheck['id'];

    if ($estadoExistente === 'pendiente') {
        header("Location: pago_estado.php");
        exit();
    }
    if ($estadoExistente === 'aprobado') {
        $_SESSION['aprobado_club'] = $club;
        $_SESSION['aprobado_cred'] = $codigo;
        header("Location: aprobado.php");
        exit();
    }
    if ($estadoExistente === 'rechazado') {
        header("Location: pago.php");
        exit();
    }
}

// Si el club es gratuito
if ($club_data['tipo'] === 'gratis') {
    $stmtDup = $conn->prepare("SELECT id FROM estudiantes WHERE codigo_credencial = ? AND club = ?");
    $stmtDup->bind_param("ss", $codigo, $club);
    $stmtDup->execute();
    $resDup = $stmtDup->get_result();

    if (!($resDup && $resDup->num_rows > 0)) {
        $sql2 = "INSERT INTO estudiantes (apellidos, nombres, curso, codigo_credencial, celular, club, precio, estado, fecha_inscripcion)
                VALUES (?, ?, ?, ?, ?, ?, ?, ?, NOW())";
        $stmt2 = $conn->prepare($sql2);
        $estado = 'aprobado';
        $precio_gratis = 0.0;
        $stmt2->bind_param(
            "ssssssds",
            $apellidos,
            $nombres,
            $curso,
            $codigo,
            $celular_enc,
            $club,
            $precio_gratis,
            $estado
        );
        $stmt2->execute();
        $newId = $stmt2->insert_id;
        $_SESSION['student_data']['insc_id'] = $newId;
    }

    header("Location: aprobado.php");
    exit();
}

// Si el club es de pago
$available = ($club_data['limite'] === NULL || $club_data['inscritos'] < $club_data['limite']);
if ($available) {
    $stmtDup2 = $conn->prepare("SELECT id FROM estudiantes WHERE codigo_credencial = ? AND club = ?");
    $stmtDup2->bind_param("ss", $codigo, $club);
    $stmtDup2->execute();
    $resDup2 = $stmtDup2->get_result();

    if (!($resDup2 && $resDup2->num_rows > 0)) {
        $sql3 = "INSERT INTO estudiantes (apellidos, nombres, curso, codigo_credencial, celular, club, precio, fecha_inscripcion)
                VALUES (?, ?, ?, ?, ?, ?, ?, NOW())";
        $stmt3 = $conn->prepare($sql3);
        $stmt3->bind_param(
            "ssssssd",
            $apellidos,
            $nombres,
            $curso,
            $codigo,
            $celular_enc,
            $club,
            $club_data['precio']
        );
        $stmt3->execute();
        $newId2 = $stmt3->insert_id;
        $_SESSION['student_data']['insc_id'] = $newId2;
    }

    header("Location: pago.php");
    exit();
} else {
    echo "<h2>No hay cupo disponible</h2>";
    echo "<a href='formulario.php'><button>Volver al formulario</button></a>";
    exit();
}

$conn->close();
?>