<?php
// /formulario/procesar_pago.php - Mejorado: Mejor validación de archivo, código secreto
session_start();
require_once "config.php";

if ($_SERVER['REQUEST_METHOD'] !== 'POST' || !validateCSRF($_POST['csrf'] ?? '')) {
    http_response_code(400);
    die("Solicitud inválida.");
}

if (!isset($_SESSION['student_data'])) {
    die("Faltan datos del estudiante.");
}

// Validación mejorada del archivo
if (!isset($_FILES['comprobante']) || $_FILES['comprobante']['error'] !== UPLOAD_ERR_OK) {
    die("Error al subir el comprobante.");
}
if ($_FILES['comprobante']['size'] > 2097152) { // 2MB máximo
    die("El archivo es demasiado grande (máximo 2MB).");
}
$finfo = finfo_open(FILEINFO_MIME_TYPE);
$mime = finfo_file($finfo, $_FILES['comprobante']['tmp_name']);
finfo_close($finfo);
if ($mime !== 'application/pdf') {
    die("Solo se permiten archivos PDF.");
}

// Limpia nombre del archivo
$filename = time() . '_' . preg_replace('/[^a-zA-Z0-9.-]/', '', basename($_FILES['comprobante']['name']));

// Guardar en carpeta segura
$uploadDir = dirname(__DIR__) . '/uploads/';
if (!is_dir($uploadDir)) {
    mkdir($uploadDir, 0755, true);
}
$target = $uploadDir . $filename;

if (!move_uploaded_file($_FILES['comprobante']['tmp_name'], $target)) {
    die("No se pudo guardar el archivo.");
}

$metodo_pago = filter_var($_POST['metodo_pago'] ?? '', FILTER_SANITIZE_STRING);
$codigo = $_SESSION['student_data']['codigo_credencial'] ?? '';
$club = $_SESSION['club_data']['nombre'] ?? ($_POST['club_hidden'] ?? '');
$insc_id = $_SESSION['student_data']['insc_id'] ?? ($_POST['insc_id_hidden'] ?? null);

// Actualiza con fecha
if ($insc_id && is_numeric($insc_id)) {
    $stmt = $conn->prepare("UPDATE estudiantes SET metodo_pago=?, comprobante=?, estado='pendiente', fecha_inscripcion=NOW() WHERE id=?");
    $stmt->bind_param("ssi", $metodo_pago, $filename, $insc_id);
} else {
    $stmt = $conn->prepare("UPDATE estudiantes SET metodo_pago=?, comprobante=?, estado='pendiente', fecha_inscripcion=NOW() WHERE codigo_credencial=? AND club=?");
    $stmt->bind_param("ssss", $metodo_pago, $filename, $codigo, $club);
}

if (!$stmt->execute()) {
    error_log("Error al actualizar: " . $stmt->error);
    die("Error interno. Intenta de nuevo.");
}

$stmt->close();
header("Location: pago_estado.php");
exit();
?>

die("Método no permitido.");