<?php
session_start();
require_once "config.php";
$conn->set_charset("utf8mb4");

if (!isset($_SESSION['student_data'])) {
    die("Acceso no permitido.");
}
$student = $_SESSION['student_data'];
$codigo = $student['codigo_credencial'] ?? '';
$nombres = $student['nombres'] ?? 'Estudiante';
$apellidos = $student['apellidos'] ?? '';
$nombreCompleto = trim("$nombres $apellidos");

if (!$codigo) {
    die("Código de credencial no definido.");
}

if (!isset($_SESSION['club_data']['nombre'])) {
    die("Club no definido para mostrar estado.");
}
$club = $_SESSION['club_data']['nombre'];

// Obtener estado y fecha
$stmt = $conn->prepare(
    "SELECT estado, fecha_inscripcion FROM estudiantes WHERE codigo_credencial = ? AND club = ?"
);
$stmt->bind_param("ss", $codigo, $club);
$stmt->execute();
$res = $stmt->get_result();

$estado = "Estado no disponible";
$fecha = "";
if ($res && $res->num_rows > 0) {
    $row = $res->fetch_assoc();
    $estado = $row['estado'];
    $fecha = $row['fecha_inscripcion'] ?? "";
}
?>
<!DOCTYPE html>
<html lang="es">
<head>
<meta charset="UTF-8">
<meta http-equiv="refresh" content="60">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Estado de Inscripción</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
/* ===== MENU SUPERIOR IGUAL AL FORMULARIO ===== */
header {
  background: linear-gradient(90deg, #0077b6, #f72585);
  padding: 20px 60px;
  display: flex;
  justify-content: space-between;
  align-items: center;
  position: fixed;
  top: 0;
  width: 100%;
  z-index: 1000;
  box-shadow: 0 4px 15px rgba(0, 0, 0, 0.2);
  animation: slideDown 0.6s ease forwards;
}
header h1 {
  font-size: 28px;
  color: #fff;
  letter-spacing: 1px;
  text-shadow: 1px 2px 4px rgba(0, 0, 0, 0.3);
}
nav a {
  color: #fff;
  margin: 0 15px;
  font-weight: 600;
  padding: 8px 14px;
  border-radius: 8px;
  transition: all 0.3s ease;
  text-decoration: none;
}
nav a:hover {
  background: #fff;
  color: #0077b6;
  transform: translateY(-2px);
  box-shadow: 0 4px 10px rgba(255, 255, 255, 0.3);
}
@keyframes slideDown {
  from { transform: translateY(-100%); opacity: 0; }
  to { transform: translateY(0); opacity: 1; }
}

/* ===== FONDO ANIMADO ===== */
body {
  margin: 0;
  font-family: 'Poppins', Arial, sans-serif;
  background: linear-gradient(120deg, #dbe9ff, #ffe0f3, #d7f5ff);
  background-size: 300% 300%;
  animation: fondoAnimado 10s ease infinite;
  padding-top: 130px;
}
@keyframes fondoAnimado {
  0% { background-position: 0% 50%; }
  50% { background-position: 100% 50%; }
  100% { background-position: 0% 50%; }
}

/* ===== CONTENEDOR PRINCIPAL ===== */
.container-content {
  max-width: 750px;
  margin: 50px auto;
  background: #fff;
  padding: 35px;
  border-radius: 25px;
  box-shadow: 0 15px 35px rgba(0,0,0,0.2);
  animation: fadeInUp 0.8s ease forwards;
  opacity: 0;
  transform: translateY(30px);
}
@keyframes fadeInUp {
  to { opacity: 1; transform: translateY(0); }
}

h2 {
  color: #1e3c72;
  margin-bottom: 20px;
  text-align: center;
  font-weight: bold;
}
p {
  font-size: 1.1rem;
  margin-bottom: 15px;
}

/* ===== ESTADOS ===== */
.estado-pendiente { color: #d68c00; font-weight: bold; }
.estado-rechazado { color: #d10000; font-weight: bold; }
.estado-aprobado { color: #007700; font-weight: bold; }

/* ===== CARD FACTURA ===== */
.factura {
  border: 2px solid #0077b6;
  border-radius: 15px;
  padding: 25px;
  background: #fefefe;
  box-shadow: 0 6px 12px rgba(0,0,0,0.1);
  margin-top: 20px;
}
.factura h3 {
  color: #0077b6;
  margin-bottom: 10px;
  text-align: center;
}
.factura p { font-size: 1rem; margin: 6px 0; }
.factura .linea {
  border-top: 1px solid #ccc;
  margin: 10px 0 15px 0;
}
.factura strong { color: #1e3c72; }

/* ===== BOTÓN ===== */
button {
  background: linear-gradient(90deg, #1e3c72, #ff2d95);
  color: #fff;
  border: none;
  padding: 12px 20px;
  border-radius: 12px;
  font-weight: bold;
  transition: 0.3s;
  cursor: pointer;
  box-shadow: 0 8px 25px rgba(0, 0, 0, 0.25);
}
button:hover {
  transform: scale(1.05);
  box-shadow: 0 12px 35px rgba(0, 0, 0, 0.35);
}

/* RESPONSIVO */
@media (max-width: 768px) {
  header {
    flex-direction: column;
    gap: 10px;
    padding: 15px 20px;
    text-align: center;
  }
  nav a { margin: 5px; }
  .container-content { padding: 25px; }
}
</style>
</head>
<body>

<header>
  <h1>CLUBES MARANATA</h1>
  <nav>
      <a href="index.html">Inicio</a>
      <a href="formulario/formulario.php">Formulario</a>
      <a href="admin/login.php">Admin</a>
      <a href="ayuda.html">Ayuda</a>
  </nav>
</header>

<div class="container-content">
  <h2>Estado de la inscripción al club <strong><?php echo htmlspecialchars($club); ?></strong></h2>
  <p><strong>Estudiante:</strong> <?php echo htmlspecialchars($nombreCompleto); ?></p>
  <p><strong>Estado:</strong> 
    <span class="<?php 
        echo $estado === 'pendiente' ? 'estado-pendiente' : 
             ($estado === 'rechazado' ? 'estado-rechazado' : 
             ($estado === 'aprobado' ? 'estado-aprobado' : '')); 
    ?>">
    <?php echo htmlspecialchars($estado); ?>
    </span>
  </p>

  <?php if ($estado === 'pendiente'): ?>
    <p>Su comprobante está pendiente de revisión. Por favor espere.</p>

  <?php elseif ($estado === 'rechazado'): ?>
    <p>Su comprobante ha sido rechazado. Puede reenviar el comprobante:</p>
    <a href="pago.php"><button>Reenviar comprobante</button></a>

  <?php elseif ($estado === 'aprobado'): ?>
    <div class="factura">
      <h3>¡Fuiste aprobado con exito!</h3>
      <div class="linea"></div>
      <p><strong>Nombre:</strong> <?php echo htmlspecialchars($nombreCompleto); ?></p>
      <p><strong>Club:</strong> <?php echo htmlspecialchars($club); ?></p>
      <p><strong>Fecha de aprobación:</strong> <?php echo htmlspecialchars($fecha ?: date("d/m/Y")); ?></p>
      <p><strong>Estado:</strong> ✅ Aprobado exitosamente</p>
      <div class="linea"></div>
      <p style="text-align:center;">¡Bienvenido al club de <strong><?php echo htmlspecialchars($club); ?></strong>! 🎉</p>
    </div>
  <?php else: ?>
    <p>Estado desconocido: <?php echo htmlspecialchars($estado); ?></p>
  <?php endif; ?>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
