<?php
session_start();
require_once "config.php";

// Verifica que exista club_data
if (!isset($_SESSION['club_data']) || !isset($_SESSION['club_data']['precio'])) {
    die("No se encontró el precio o datos del club. Vuelve al formulario.");
}

$club_data = $_SESSION['club_data'];
$precio = $club_data['precio'];
$clubNombre = $club_data['nombre'] ?? '';
$insc_id = $_SESSION['student_data']['insc_id'] ?? '';
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>Pago – Subir comprobante</title>
    <style>
/* ======== ESTILOS GENERALES ======== */
* {
    margin: 0;
    padding: 0;
    box-sizing: border-box;
}

body {
    font-family: 'Poppins', sans-serif;
    background: #f1f4fb;
    color: #222;
    padding-top: 100px; /* espacio para header fijo */
}

/* ======== MENÚ SUPERIOR ======== */
header {
  background: linear-gradient(90deg, #0077b6, #f72585);
  padding: 15px 50px;
  display: flex;
  justify-content: space-between;
  align-items: center;
  position: fixed;
  top: 0;
  width: 100%;
  z-index: 1000;
  box-shadow: 0 4px 12px rgba(0,0,0,0.15);
  transition: 0.3s;
}

header h1 {
  font-size: 26px;
  color: #fff;
  letter-spacing: 1px;
}

nav {
  display: flex;
  flex-wrap: wrap;
  justify-content: center;
  align-items: center;
}

nav a {
  color: #fff;
  margin: 0 10px;
  font-weight: 600;
  padding: 8px 14px;
  border-radius: 8px;
  text-decoration: none;
  transition: all 0.3s ease;
}

nav a:hover {
  background: #fff;
  color: #0077b6;
  transform: scale(1.05);
}

/* ======== CONTENIDO PRINCIPAL EN DOS COLUMNAS ======== */
main {
    max-width: 1000px;
    margin: 60px auto;
    background: #fff;
    padding: 40px;
    border-radius: 15px;
    box-shadow: 0 6px 20px rgba(0,0,0,0.1);
    display: flex;
    gap: 40px;
    flex-wrap: wrap;
}

/* Columna izquierda: QR + datos bancarios */
.payment-info {
    flex: 1;
    min-width: 280px;
    text-align: center;
}

.payment-info img {
    width: 250px;
    height: 250px;
    object-fit: contain;
    margin-bottom: 20px;
    border-radius: 12px;
    box-shadow: 0 4px 12px rgba(0,0,0,0.15);
}

.bank-details {
    background: #f8f9fc;
    padding: 15px;
    border-radius: 12px;
    box-shadow: 0 4px 12px rgba(0,0,0,0.1);
    text-align: left;
    font-size: 16px;
    color: #333;
}

.bank-details p {
    margin-bottom: 8px;
}

/* Columna derecha: Formulario existente */
.payment-form {
    flex: 1;
    min-width: 300px;
    text-align: center;
}

h2 {
    color: #0077b6;
    margin-bottom: 10px;
    font-size: 26px;
}

p {
    color: #444;
    font-size: 18px;
    margin-bottom: 20px;
}

/* FORMULARIO */
form {
    display: flex;
    flex-direction: column;
    align-items: center;
}

label {
    font-weight: 600;
    margin-bottom: 8px;
    color: #333;
}

input[type="file"] {
    width: 100%;
    padding: 10px;
    margin-bottom: 25px;
    border: 2px solid #0077b6;
    border-radius: 8px;
    background: #f8f9fc;
    transition: border-color 0.3s;
}

input[type="file"]:hover {
    border-color: #f72585;
}

/* BOTONES */
button {
    width: 80%;
    background: linear-gradient(90deg, #0077b6, #f72585);
    color: white;
    border: none;
    padding: 12px;
    margin: 8px 0;
    border-radius: 10px;
    cursor: pointer;
    font-weight: 600;
    font-size: 16px;
    transition: transform 0.3s ease, opacity 0.3s ease;
}

button:hover {
    opacity: 0.9;
    transform: translateY(-3px);
}

/* RESPONSIVE */
@media (max-width: 768px) {
    header {
        flex-direction: column;
        gap: 8px;
        padding: 15px 20px;
    }

    nav a {
        margin: 5px;
        font-size: 14px;
    }

    main {
        margin: 40px 20px;
        padding: 25px;
        flex-direction: column;
        gap: 30px;
    }

    .payment-info img {
        width: 100%;
        height: auto;
    }
}
    </style>
</head>
<body>

<!-- MENÚ SUPERIOR -->
<header>
    <h1>CLUBES MARANATA</h1>
    <nav>
      <a href="index.html">Inicio</a>
      <a href="formulario/formulario.php">Formulario</a>
      <a href="admin/login.php">Admin</a>
      <a href="ayuda.html">Ayuda</a>
    </nav>
</header>

<!-- CONTENIDO PRINCIPAL -->
<main>

    <!-- IZQUIERDA: QR + Banco -->
    <div class="payment-info">
        <h2>Pago mediante QR / Transferencia</h2>
        <img src="qr.jpeg" alt="Código QR para pago">

        <div class="bank-details">
            <p><strong>Banco:</strong> Banco Ejemplo</p>
            <p><strong>Cuenta:</strong> 1234 5678 9012 3456</p>
            <p><strong>Titular:</strong> U.E. Plena Maranata</p>
            <p><strong>Tipo:</strong> Cuenta Corriente</p>
        </div>
    </div>

    <!-- DERECHA: Formulario existente -->
    <div class="payment-form">
        <h2>Pago del club</h2>
        <p><strong>Club:</strong> <?php echo htmlspecialchars($clubNombre); ?></p>
        <p><strong>Precio:</strong> $<?php echo htmlspecialchars($precio); ?></p>
    <form action="procesar_pago.php" method="POST" enctype="multipart/form-data">
    <!-- CSRF para validar la solicitud -->
        <input type="hidden" name="csrf" value="<?php echo generateCSRF(); ?>">
        <input type="hidden" name="club_hidden" value="<?php echo htmlspecialchars($clubNombre); ?>">
        <input type="hidden" name="insc_id_hidden" value="<?php echo htmlspecialchars($insc_id); ?>">

        <label for="comprobante">Subir Comprobante (PDF):</label>
        <input type="file" name="comprobante" accept="application/pdf" required>

        <button type="submit" name="metodo_pago" value="QR">💳 Enviar pago por QR</button>
        <button type="submit" name="metodo_pago" value="Transferencia">🏦 Enviar pago por Transferencia</button>
</form>


    </div>

</main>

</body>
</html>
