<?php
// === Diagnóstico temporal (puedes quitar después de probar) ===
error_reporting(E_ALL);
ini_set('display_errors', 1);

// === Cargar configuración y funciones de seguridad ===
require_once __DIR__ . "/config.php";
?>
<!DOCTYPE html>
<html lang="es">
<head>
<meta charset="UTF-8">
<title>Inscripción a Clubes</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
/* ===== ESTILOS DEL MENU SUPERIOR ===== */
header {
  background: linear-gradient(90deg, #0077b6, #f72585);
  padding: 20px 60px;
  display: flex;
  justify-content: space-between;
  align-items: center;
  position: fixed;
  top: 0;
  width: 100%;
  z-index: 1000;
  box-shadow: 0 4px 15px rgba(0, 0, 0, 0.2);
  animation: slideDown 0.6s ease forwards;
}

header h1 {
  font-size: 28px;
  color: #fff;
  letter-spacing: 1px;
  text-shadow: 1px 2px 4px rgba(0, 0, 0, 0.3);
}

nav a {
  color: #fff;
  margin: 0 15px;
  font-weight: 600;
  padding: 8px 14px;
  border-radius: 8px;
  transition: all 0.3s ease;
  text-decoration: none;
}

nav a:hover {
  background: #fff;
  color: #0077b6;
  transform: translateY(-2px);
  box-shadow: 0 4px 10px rgba(255, 255, 255, 0.3);
}

/* Animación del header */
@keyframes slideDown {
  from { transform: translateY(-100%); opacity: 0; }
  to { transform: translateY(0); opacity: 1; }
}

/* ===== BODY Y FONDO ANIMADO ===== */
body {
  margin: 0;
  font-family: 'Poppins', Arial, sans-serif;
  background: linear-gradient(120deg, #dbe9ff, #ffe0f3, #d7f5ff);
  background-size: 300% 300%;
  animation: fondoAnimado 10s ease infinite;
  display: flex;
  justify-content: center;
  align-items: flex-start;
  min-height: 100vh;
  padding-top: 120px;
}

@keyframes fondoAnimado {
  0% { background-position: 0% 50%; }
  50% { background-position: 100% 50%; }
  100% { background-position: 0% 50%; }
}

/* ===== CONTENEDOR PRINCIPAL ===== */
.formulario-container {
  width: 100%;
  max-width: 750px;
  margin: 3rem auto;
  padding: 0 20px;
  box-sizing: border-box;
}

/* ===== NOTA DE ADVERTENCIA ===== */
.nota {
  background: #ff2d95;
  color: #fff;
  padding: 14px 25px;
  border-radius: 15px;
  margin-bottom: 30px;
  font-weight: bold;
  font-size: 16px;
  text-align: center;
  box-shadow: 0 6px 20px rgba(255, 45, 149, 0.4);
}

/* ===== FORMULARIO CON FONDO ===== */
.formulario-fondo {
  background: linear-gradient(145deg, #b4d7f7ff, #fcbfedff);
  padding: 45px 40px;
  border-radius: 25px;
  box-shadow: 0 15px 35px rgba(0, 0, 0, 0.2);
  color: #333;
  opacity: 0;
  transform: translateY(30px);
  animation: fadeInUp 0.8s ease forwards;
}

@keyframes fadeInUp {
  from { opacity: 0; transform: translateY(30px); }
  to { opacity: 1; transform: translateY(0); }
}

.formulario-fondo h2 {
  font-size: 28px;
  margin-bottom: 10px;
  color: #1e3c72;
  text-align: center;
  text-shadow: 0 1px 2px rgba(0,0,0,0.15);
}

.formulario-fondo p {
  font-size: 15px;
  margin-bottom: 25px;
  color: #444;
  text-align: center;
}

/* ===== CAMPOS Y FORMULARIO ===== */
form {
  display: grid;
  gap: 22px;
}

.input-group {
  display: flex;
  flex-direction: column;
  gap: 8px;
}

label {
  font-weight: bold;
  color: #ff2d95;
  font-size: 14px;
}

input, select {
  width: 100%;
  padding: 14px 15px;
  border-radius: 12px;
  border: 1px solid #ccc;
  font-size: 15px;
  background: #f9f9f9;
  transition: all 0.3s ease;
}

input:focus, select:focus {
  border-color: #ff2d95;
  background: #fff;
  outline: none;
  box-shadow: 0 0 10px rgba(255, 45, 149, 0.3);
}

/* ===== BOTÓN DE ENVÍO ===== */
button {
  padding: 16px;
  font-size: 16px;
  font-weight: bold;
  border: none;
  border-radius: 15px;
  cursor: pointer;
  background: linear-gradient(90deg, #1e3c72, #ff2d95);
  color: #fff;
  transition: transform 0.3s, box-shadow 0.3s;
  box-shadow: 0 8px 25px rgba(0, 0, 0, 0.25);
}

button:hover {
  transform: scale(1.05);
  box-shadow: 0 12px 35px rgba(0, 0, 0, 0.35);
}

/* ===== CAMPOS LADO A LADO ===== */
.row {
  display: flex;
  gap: 40px;
  flex-wrap: wrap;
}

.col {
  flex: 1;
  min-width: 150px;
  padding: 0 5px;
}

/* ===== RESPONSIVO ===== */
@media (max-width: 768px) {
  header {
    flex-direction: column;
    gap: 10px;
    padding: 15px 20px;
    text-align: center;
  }
  nav a { margin: 5px; }
  .row { flex-direction: column; gap: 15px; }
}
</style>
</head>
<body>

<!-- ===== MENU SUPERIOR ===== -->
<header>
  <h1>CLUBES MARANATA</h1>
  <nav>
      <a href="../index.html">Inicio</a>
      <a href="formulario.php">Formulario</a>
      <a href="../admin/login.php">Admin</a>
      <a href="../ayuda.html">Ayuda</a>
  </nav>
</header>

<!-- ===== CONTENIDO ===== -->
<div class="formulario-container">
  <div class="nota">
    ⚠️ Por favor, ingrese sus datos con cuidado. Verifique que sean correctos antes de enviar para evitar errores o conflictos.
  </div>

  <div class="formulario-fondo">
    <h2>Inscripción a Clubes</h2>
    <p>Complete sus datos y seleccione el club al que desea inscribirse.</p>

    <form id="inscriptionForm" action="verificar_disponibilidad.php" method="POST">
        <!-- Código secreto para seguridad -->
        <input type="hidden" name="csrf" value="<?php echo generateCSRF(); ?>">

      <div class="row">
        <div class="col input-group">
          <label for="apellidos">Apellidos</label>
          <input type="text" id="apellidos" name="apellidos" placeholder="Ingrese sus apellidos" required>
        </div>
        <div class="col input-group">
          <label for="nombres">Nombres</label>
          <input type="text" id="nombres" name="nombres" placeholder="Ingrese sus nombres" required>
        </div>
      </div>

      <div class="input-group">
        <label for="curso">Curso</label>
        <select id="curso" name="curso" required>
          <option value="" disabled selected>Seleccione un curso</option>
          <option value="1ro A">1ro A</option>
          <option value="1ro B">1ro B</option>
          <option value="2do A">2do A</option>
          <option value="2do B">2do B</option>
          <option value="3ro Sistemas">3ro Sistemas</option>
          <option value="4to Sistemas">4to Sistemas</option>
          <option value="5to Sistemas">5to Sistemas</option>
          <option value="6to Sistemas">6to Sistemas</option>
        </select>
      </div>

      <div class="row">
        <div class="col input-group">
          <label for="codigo_credencial">Código de Credencial</label>
          <input type="number" id="codigo_credencial" name="codigo_credencial" placeholder="4 dígitos" required
                 min="0" max="9999" oninput="this.value=this.value.slice(0,4)">
        </div>
        <div class="col input-group">
          <label for="celular">Celular</label>
          <input type="number" id="celular" name="celular" placeholder="8 dígitos" required
                 min="0" max="99999999" on                  min="0" max="99999999" oninput="this.value=this.value.slice(0,8)">
        </div>
      </div>

      <div class="input-group">
        <label for="club">Club</label>
        <select id="club" name="club" required>
          <option value="" disabled selected>Seleccione un club</option>
          <?php
          $conn_local = new mysqli("localhost", "root", "", "inscripciones_clubes");
          if ($conn_local->connect_error) {
              die("<option disabled>Error de conexión</option>");
          }
          $sql_local = "SELECT nombre FROM clubes";
          $result_local = $conn_local->query($sql_local);
          if ($result_local && $result_local->num_rows > 0) {
              while ($row_local = $result_local->fetch_assoc()) {
                  echo "<option value='" . htmlspecialchars($row_local['nombre']) . "'>" . htmlspecialchars($row_local['nombre']) . "</option>";
              }
          } else {
              echo "<option disabled>No hay clubes disponibles</option>";
          }
          $conn_local->close();
          ?>
        </select>
      </div>

      <!-- ===== Casilla de consentimiento ===== -->
      <div class="input-group">
        <label>
          <input type="checkbox" name="consent" required>
          Acepto que mis datos sean usados para fines administrativos según la 
          <a href="#" data-bs-toggle="modal" data-bs-target="#modalPrivacidad" style="color: #0077b6; font-weight: bold; text-decoration: underline;">
            Política de Privacidad
          </a>.
        </label>
      </div>

      <button type="submit">Enviar</button>
    </form>
  </div>
</div>

<!-- ===== Modal de Política de Privacidad ===== -->
<div class="modal fade" id="modalPrivacidad" tabindex="-1" aria-labelledby="modalPrivacidadLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered modal-lg">
    <div class="modal-content" style="border-radius: 20px; overflow: hidden; box-shadow: 0 5px 20px rgba(0,0,0,0.2);">

      <!-- Header con gradiente azul-fucsia -->
      <div class="modal-header" style="background: linear-gradient(90deg, #0077b6, #f72585); color: white;">
        <h5 class="modal-title" id="modalPrivacidadLabel">Política de Privacidad</h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Cerrar"></button>
      </div>

      <!-- Cuerpo del modal -->
      <div class="modal-body" style="padding: 30px; background: #f8f9fa; color: #111; font-family: 'Poppins', sans-serif;">
        <p>
          La información que proporcione en este formulario será utilizada únicamente para fines administrativos y de organización de los clubes.
        </p>
        <p>
          Sus datos se tratarán de forma confidencial y solo el personal autorizado tendrá acceso a ellos.
        </p>
        <p>
          Al marcar la casilla de consentimiento, usted acepta que sus datos sean utilizados para estos fines.
        </p>
      </div>

      <!-- Footer -->
      <div class="modal-footer" style="background: #f1f1f1;">
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
      </div>

    </div>
  </div>
</div>

<!-- Script Bootstrap -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>

