<?php
// formulario/config.php - Enhanced for 2025 security
if (session_status() === PHP_SESSION_NONE) {
    session_start([
        'cookie_httponly' => true,
        'cookie_secure' => true, // Requiere HTTPS
        'cookie_samesite' => 'Strict'
    ]);
}

// DB Connection
$host = "localhost";
$user = "root";
$pass = "";
$db = "inscripciones_clubes";
$conn = new mysqli($host, $user, $pass, $db);
if ($conn->connect_error) {
    error_log("DB Connection Error: " . $conn->connect_error);
    http_response_code(500);
    exit("Error de conexión a la base de datos.");
}
$conn->set_charset("utf8mb4");

// Security Headers
header('X-Frame-Options: DENY');
header('X-Content-Type-Options: nosniff');
header('Strict-Transport-Security: max-age=31536000; includeSubDomains');
header("Content-Security-Policy: default-src 'self'; script-src 'self' 'unsafe-inline' https://cdn.jsdelivr.net; style-src 'self' 'unsafe-inline' https://fonts.googleapis.com https://cdn.jsdelivr.net; font-src 'self' https://fonts.gstatic.com;");

// CSRF Token
function generateCSRF() {
    if (empty($_SESSION['csrf_token'])) {
        $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
    }
    return $_SESSION['csrf_token'];
}

function validateCSRF($token) {
    return isset($_SESSION['csrf_token']) && hash_equals($_SESSION['csrf_token'], $token);
}

// Encryption
$encrypt_key = hash('sha256', $_ENV['ENCRYPT_KEY'] ?? 'fallback_secure_key_change_me');
function encryptData($data) {
    global $encrypt_key;
    return base64_encode(openssl_encrypt($data, 'AES-256-CBC', $encrypt_key, 0, substr($encrypt_key, 0, 16)));
}
function decryptData($data) {
    global $encrypt_key;
    return openssl_decrypt(base64_decode($data), 'AES-256-CBC', $encrypt_key, 0, substr($encrypt_key, 0, 16));
}

// Rate Limit
function checkRateLimit($action = 'login') {
    $ip = $_SERVER['REMOTE_ADDR'] ?? 'unknown';
    $key = "rate_{$action}_{$ip}";
    if (!isset($_SESSION[$key])) {
        $_SESSION[$key] = ['count' => 0, 'time' => time()];
    }
    $rate = &$_SESSION[$key];
    if (time() - $rate['time'] > 900) {
        $rate = ['count' => 0, 'time' => time()];
    }
    if ($rate['count'] >= 5) {
        error_log("Rate limit exceeded for IP: $ip on $action");
        return false;
    }
    $rate['count']++;
    return true;
}

function isAdminLoggedIn() {
    return isset($_SESSION['admin']) && $_SESSION['admin'] === true;
}

function requireAdmin() {
    if (!isAdminLoggedIn()) {
        header("Location: login.php?unauth=1");
        exit();
    }
}
