<?php
session_start();
require_once "config.php";

if (!isset($_SESSION['aprobado_club']) || !isset($_SESSION['aprobado_cred'])) {
    header("Location: index.php");
    exit();
}

$club = $_SESSION['aprobado_club'];
$cred = $_SESSION['aprobado_cred'];

unset($_SESSION['aprobado_club']);
unset($_SESSION['aprobado_cred']);
unset($_SESSION['student_data']);
unset($_SESSION['club_data']);
?>
<!DOCTYPE html>
<html lang="es">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>Solicitud Aprobada</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;600;700&display=swap" rel="stylesheet">
<style>
/* ====== HEADER / MENÚ ====== */
header {
  background: linear-gradient(90deg, #0077b6, #f72585);
  padding: 20px 60px;
  display: flex;
  justify-content: space-between;
  align-items: center;
  position: fixed;
  top: 0;
  width: 100%;
  z-index: 1000;
  box-shadow: 0 4px 15px rgba(0,0,0,0.2);
  animation: slideDown 0.7s ease forwards;
}

@keyframes slideDown {
  from { transform: translateY(-100%); opacity: 0; }
  to { transform: translateY(0); opacity: 1; }
}

header h1 {
  font-size: 28px;
  color: #fff;
  letter-spacing: 1px;
  text-shadow: 1px 2px 5px rgba(0,0,0,0.3);
}

nav a {
  color: #fff;
  margin: 0 15px;
  font-weight: 600;
  padding: 8px 14px;
  border-radius: 8px;
  transition: 0.3s;
  text-decoration: none;
}

nav a:hover {
  background: #fff;
  color: #0077b6;
  transform: translateY(-2px);
  box-shadow: 0 3px 10px rgba(255,255,255,0.3);
}

/* ====== FONDO ANIMADO ====== */
body {
  margin: 0;
  font-family: 'Poppins', sans-serif;
  background: linear-gradient(120deg, #b8e3ff, #ffe3f3, #d0f0ff);
  background-size: 300% 300%;
  animation: fondoAnimado 10s ease infinite;
  min-height: 100vh;
  display: flex;
  flex-direction: column;
  justify-content: center;
  align-items: center;
  padding-top: 120px;
  overflow-x: hidden;
}

@keyframes fondoAnimado {
  0% { background-position: 0% 50%; }
  50% { background-position: 100% 50%; }
  100% { background-position: 0% 50%; }
}

/* ====== ELEMENTOS DECORATIVOS ====== */
.burbuja {
  position: absolute;
  border-radius: 50%;
  background: rgba(255,255,255,0.25);
  animation: subir 8s infinite ease-in-out;
  z-index: 0;
}
@keyframes subir {
  0% { transform: translateY(0) scale(1); opacity: 1; }
  100% { transform: translateY(-1200px) scale(1.5); opacity: 0; }
}

/* ====== TARJETA PRINCIPAL ====== */
.success-wrapper {
  flex: 1;
  display: flex;
  align-items: center;
  justify-content: center;
  z-index: 1;
  padding: 20px;
}

.success-card {
  background: rgba(255, 255, 255, 0.9);
  backdrop-filter: blur(15px);
  border-radius: 25px;
  padding: 60px 50px;
  text-align: center;
  box-shadow: 0 20px 45px rgba(0, 0, 0, 0.15);
  max-width: 520px;
  width: 100%;
  animation: fadeUp 0.8s ease-out;
}

@keyframes fadeUp {
  from { opacity: 0; transform: translateY(40px); }
  to { opacity: 1; transform: translateY(0); }
}

/* ====== CONTENIDO ====== */
.success-icon {
  font-size: 90px;
  color: #27ae60;
  margin-bottom: 20px;
  animation: bounce 1.5s ease-in-out;
}

@keyframes bounce {
  0%, 20%, 50%, 80%, 100% { transform: translateY(0); }
  40% { transform: translateY(-15px); }
  60% { transform: translateY(-8px); }
}

.success-card h2 {
  color: #1e3c72;
  font-size: 30px;
  margin-bottom: 10px;
  font-weight: 700;
  text-transform: uppercase;
  letter-spacing: 1px;
}

.success-card p {
  font-size: 16px;
  color: #444;
  margin-bottom: 15px;
  line-height: 1.6;
}

.club-highlight {
  background: linear-gradient(135deg, #e3f2fd, #f3e5f5);
  padding: 25px;
  border-radius: 15px;
  margin: 25px 0;
  box-shadow: 0 8px 20px rgba(0,0,0,0.1);
  font-weight: 600;
  color: #1e3c72;
}

/* ====== BOTÓN ====== */
.btn-volver {
  background: linear-gradient(90deg, #1e3c72, #ff2d95);
  color: #fff;
  border: none;
  border-radius: 50px;
  padding: 15px 40px;
  font-size: 16px;
  font-weight: 600;
  text-decoration: none;
  display: inline-block;
  transition: 0.3s ease;
  box-shadow: 0 10px 25px rgba(30, 60, 114, 0.3);
}

.btn-volver:hover {
  transform: translateY(-3px);
  box-shadow: 0 15px 35px rgba(30, 60, 114, 0.4);
  text-decoration: none;
}

/* ====== RESPONSIVO ====== */
@media (max-width: 768px) {
  header { flex-direction: column; gap: 10px; padding: 15px 20px; }
  nav a { margin: 5px; }
  .success-card { padding: 40px 25px; margin: 10px; }
  .success-icon { font-size: 70px; }
}
</style>
</head>
<body>

<!-- ===== BURBUJAS DECORATIVAS ===== -->
<div class="burbuja" style="width:80px; height:80px; left:5%; bottom:-100px; animation-delay:0s;"></div>
<div class="burbuja" style="width:50px; height:50px; left:20%; bottom:-120px; animation-delay:2s;"></div>
<div class="burbuja" style="width:100px; height:100px; left:60%; bottom:-150px; animation-delay:4s;"></div>
<div class="burbuja" style="width:70px; height:70px; left:80%; bottom:-130px; animation-delay:6s;"></div>

<!-- ===== MENU ===== -->
<header>
  <h1>CLUBES MARANATA</h1>
  <nav>
      <a href="index.html">Inicio</a>
      <a href="formulario/formulario.php">Formulario</a>
      <a href="admin/login.php">Admin</a>
      <a href="ayuda.html">Ayuda</a> 
  </nav>
</header>

<!-- ===== TARJETA DE APROBACIÓN ===== -->
<div class="success-wrapper">
  <div class="success-card">
    <div class="success-icon">🎉</div>
    <h2>¡Felicidades!</h2>
    <p>Su solicitud ya ha sido aprobada exitosamente.</p>
    <div class="club-highlight">
      <p><strong>Club:</strong> <?= htmlspecialchars($club); ?></p>
      <p><strong>Código de Credencial:</strong> <?= htmlspecialchars($cred); ?></p>
    </div>
    <p>¡Bienvenido a la familia! Estamos emocionados de compartir esta experiencia contigo.</p>
    <a href="../index.html" class="btn-volver">Volver al inicio</a>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
