<?php
// admin/login.php - Updated: Replaced Bootstrap navbar with new menu
session_start();
require_once(__DIR__ . '/../formulario/config.php'); // Ajusta la ruta si es necesario
$error = "";

// REMOVIDO: if (isset($_SESSION['admin']) && $_SESSION['admin'] === true) { header("Location: panel_admin.php"); exit(); }

if ($_SERVER["REQUEST_METHOD"] === "POST") {
    $usuario = trim($_POST['usuario'] ?? "");
    $contrasena = $_POST['contrasena'] ?? "";

    // Buscar el usuario en la base de datos
    $sql = "SELECT * FROM admins WHERE username = ?";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $usuario);
    $stmt->execute();
    $resultado = $stmt->get_result();

    if ($resultado && $resultado->num_rows === 1) {
        $admin = $resultado->fetch_assoc();

        // Verificar contraseña (hash o texto plano según tu base)
        if (password_verify($contrasena, $admin['password']) || $contrasena === $admin['password']) {
            $_SESSION['admin'] = true; // <- ahora compatible con panel_admin.php
            $_SESSION['admin_user'] = $admin['username'];
            header("Location: panel_admin.php");
            exit();
        } else {
            $error = "Contraseña incorrecta.";
        }
    } else {
        $error = "Usuario no encontrado.";
    }
}
?>


<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Verificación de identidad</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
/* ===== ESTILOS DEL NUEVO MENU (copiados y adaptados) ===== */
header {
  background: linear-gradient(90deg, #0077b6, #f72585);
  padding: 20px 50px;
  display:flex;
  justify-content:space-between;
  align-items:center;
  position: sticky;
  top:0;
  z-index:1000;
  box-shadow:0 4px 12px rgba(0,0,0,0.15);
}
header h1 { font-size:28px; color:#fff; }
nav a { color:#fff; margin:0 15px; font-weight:600; padding:6px 12px; border-radius:6px; transition:0.3s; }
nav a:hover { background:#fff; color:#0077b6; }

/* ===== ESTILOS ORIGINALES ADAPTADOS (sin navbar Bootstrap) ===== */
* {
    box-sizing: border-box;
}

body {
    margin: 0;
    font-family: 'Poppins', sans-serif;
    background: #e3e9ecff;
    padding-top: 0px; /* Espacio para header sticky */
}

.login-container {
    display: flex;
    width: 100vw;
    height: calc(100vh - 100px);
    margin-top: 0; /* Ajustado, ya que header no es fixed-top como antes */
}

/* Panel izquierdo */
.left-panel {
    flex: 1;
    background: linear-gradient(135deg, #2b3175, #3b4495);
    color: white;
    display: flex;
    flex-direction: column;
    align-items: center;
    justify-content: center;
    text-align: center;
    padding: 20px;
}

.icon-frame {
    border: 6px solid #252d52;
    padding: 20px;
    border-radius: 5px;
    display: inline-block;
    background: rgba(255,255,255,0.05);
}

.icon-frame img {
    width: 280px;
    height: 280px;
    object-fit: contain;
}

.slogan {
    margin-top: 25px;
    font-size: 18px;
    letter-spacing: 1px;
}

/* Panel derecho */
.right-panel {
    flex: 1;
    background-color: white;
    display: flex;
    align-items: center;
    justify-content: center;
}

.form-box {
    width: 100%;
    max-width: 350px;
    text-align: center;
    padding: 20px;
}

.form-box h1 {
    color: #2c2c54;
    font-size: 24px;
    margin-bottom: 35px;
    font-weight: 700;
    text-transform: uppercase;
}

.form-group {
    margin-bottom: 20px;
    text-align: left;
}

.form-group input {
    width: 100%;
    padding: 12px 14px;
    border: 2px solid #ccc;
    border-radius: 5px;
    font-size: 15px;
    outline: none;
    transition: border-color 0.3s;
}

.form-group input:focus {
    border-color: #363c87;
}

.btn-ingresar {
    width: 100%;
    background-color: #e13ea1;
    color: white;
    border: none;
    border-radius: 5px;
    padding: 12px;
    font-size: 16px;
    font-weight: 600;
    cursor: pointer;
    transition: background-color 0.3s;
}

.btn-ingresar:hover {
    background-color: #c7338d;
}

.error {
    color: red;
    margin-bottom: 15px;
    font-weight: bold;
}

/* RESPONSIVE */
@media (max-width: 992px) {
    .login-container {
        flex-direction: column;
        height: auto;
    }

    .left-panel {
        padding: 50px 20px;
    }

    .icon-frame img {
        width: 150px;
        height: 150px;
    }

    .slogan {
        font-size: 15px;
    }

    header {
        flex-direction: column;
        gap: 10px;
        padding: 15px 20px;
    }

    nav a {
        margin: 5px;
    }
}
    </style>
</head>
<body>

<!-- NUEVO HEADER/MENU -->
<header>
    <h1>CLUBES MARANATA</h1>
    <nav>
      <a href="../index.html">Inicio</a>
      <a href="../index.html#mvo">Misión/Visión</a>
      <a href="../index.html#info">Servicios</a>
      <a href="../index.html#galeria">Galería</a>
    </nav>
</header>

    <!-- ===== CONTENIDO ===== -->
    <div class="login-container">
        <!-- Panel izquierdo -->
        <div class="left-panel">
            <div class="icon-frame">
                <img src="../img/logo.png" alt="Usuario">
            </div>
            <p class="slogan">EDUCANDO CON AMOR, CIENCIA Y DISCIPLINA </p>
        </div>

        <!-- Panel derecho -->
        <div class="right-panel">
            <div class="form-box">
                <h1>Verifica tu identidad (SOLO ADMIN)</h1>
                
                <?php if (!empty($error)): ?>
                    <div class="error"><?php echo htmlspecialchars($error); ?></div>
                <?php endif; ?>

                <form method="POST" action="">
                    <div class="form-group">
                        <input type="text" id="usuario" name="usuario" placeholder="Nombre de usuario" required>
                    </div>
                    <div class="form-group">
                        <input type="password" id="contrasena" name="contrasena" placeholder="Contraseña" required>
                    </div>
                    <button type="submit" class="btn-ingresar">Ingresar</button>
                </form>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>