<?php
require_once(__DIR__ . '/../formulario/config.php'); // Ajusta la ruta si es necesario

// Obtener parámetros
$estado = $_GET['estado'] ?? null;
$club = $_GET['club'] ?? null;

// Construir consulta con filtros
$where = [];
if ($estado) $where[] = "estado = '" . $conn->real_escape_string($estado) . "'";
if ($club) $where[] = "club = '" . $conn->real_escape_string($club) . "'";
$whereClause = !empty($where) ? 'WHERE ' . implode(' AND ', $where) : '';

$sql = "SELECT * FROM estudiantes $whereClause ORDER BY apellidos, nombres";
$result = $conn->query($sql);

if (!$result) {
    die("Error en la consulta: " . $conn->error);
}

// Generar CSV simple con numeración secuencial
header('Content-Type: text/csv; charset=utf-8');
header('Content-Disposition: attachment; filename="' . generarNombreArchivo($estado, $club) . '.csv"');
header('Cache-Control: max-age=0');

// BOM UTF-8 para tildes/accentos en Excel
echo "\xEF\xBB\xBF";

// Abrir output como archivo
$output = fopen('php://output', 'w');

// Headers (sin ID, sin Comprobante, con Nº)
fputcsv($output, ['Nº', 'Apellidos', 'Nombres', 'Curso', 'Club', 'Método Pago', 'Estado'], ';');

// Datos con numeración (1,2,3...)
$counter = 1;
while ($row = $result->fetch_assoc()) {
    $data = [
        $counter++, // 1, 2, 3...
        $row['apellidos'],
        $row['nombres'],
        $row['curso'],
        $row['club'],
        $row['metodo_pago'],
        $row['estado']
    ];
    fputcsv($output, $data, ';');
}

fclose($output);
exit;

// Función para generar el nombre del archivo
function generarNombreArchivo($estado, $club) {
    if ($club && $estado == 'aprobado') {
        return 'inscritos_' . strtolower(str_replace(' ', '_', $club)) . '_' . date('Y-m-d');
    } else {
        return 'estudiantes_' . ($club ? 'club_' . $club : ($estado ? $estado : 'todos')) . '_' . date('Y-m-d');
    }
}
?>